#include <iostream>
#include <vector>
#include <stack>
using namespace std;

long long maxVr(int N, vector<long long>& A, vector<long long>& B) {
    vector<long long> left(N), right(N);

    stack<int> s;
    for (int i = 0; i < N; i++) {
        while (!s.empty() && B[s.top()] >= B[i]) {
            s.pop();
        }
        left[i] = s.empty() ? 0 : (s.top() + 1);
        s.push(i);
    }

    while (!s.empty()) s.pop();
    for (int i = N - 1; i >= 0; i--) {
        while (!s.empty() && B[s.top()] >= B[i]) {
            s.pop();
        }
        right[i] = s.empty() ? (N - 1) : (s.top() - 1);
        s.push(i);
    }

    long long maxVrednost = 0;
    for (int i = 0; i < N; i++) {
        long long xorVrednost = 0;
        for (int j = i; j <= right[i]; j++) {
            xorVrednost ^= A[j];
            long long vrednost = xorVrednost * B[i];
            maxVrednost = max(maxVrednost, vrednost);
        }
    }

    return maxVrednost;
}

int main() {
    int N;
    cin >> N;
    vector<long long> A(N), B(N);

    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }

    for (int i = 0; i < N; i++) {
        cin >> B[i];
    }

    long long rezultat = maxVr(N, A, B);
    cout << rezultat << endl;

    return 0;
}